﻿Imports System.IO

Public Class Form1

    ' initializing file name variable
    Dim fileName As String = ""

    ' browse button opens up file explorer explorer so that the user can select a file 
    Private Sub btnBrowse_Click(sender As Object, e As EventArgs) Handles btnBrowse.Click
        If OpenFileDialog1.ShowDialog = DialogResult.OK Then
            fileName = OpenFileDialog1.FileName
            txtFileName.Text = fileName
        End If
    End Sub

    ' calculate class average button 
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        Dim total As Integer ' sum of grades
        Dim gradeCounter As Integer ' counter for grades
        Dim grade As Integer ' grade input as in file
        Dim average As Double   ' average of grades

        ' initialization phase
        total = 0
        gradeCounter = -1

        'Asks the user to select a file in the event that one is not selected
        If fileName = "" Then
            MessageBox.Show("Please select a file")
            Return
        End If

        ' processing phase... Reading the file
        Dim reader As New StreamReader(fileName)
        Dim line As String

        ' making sure the file is selected before attempting to read from it
        If reader Is Nothing Then
            MessageBox.Show("Please select a file")
            Return
        End If

        ' reading the file line by line and pulling the information for each grade, counting them, and adding them up
        Do
            line = reader.ReadLine
            grade = Convert.ToInt32(line)
            total += grade
            gradeCounter += 1
        Loop Until line Is Nothing
        reader.Close()

        ' termination phase calculates the average with the accumulated total of all grades, divided by the amount of grades counted.
        If gradeCounter <> 0 Then
            average = total / gradeCounter

            ' This displays the total of all of the grades and the count of grades in the file
            ' else statement checks to see if there are grades
            txtResults.Text = "Total of the " & gradeCounter &
                " grade(s) is " & total & vbCrLf & "Class average is " &
                String.Format("{0:F}", average)
        Else
            txtResults.Text = "No grades found"
        End If
    End Sub
End Class
